/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

// This file is meant for client applications.
// It contains all the import declarations for all the methods exported by DLL.

#ifndef __CConvenienceExports_H__
#define __CConvenienceExports_H__

using namespace ProDESKTOPLib;

HRESULT __declspec(dllimport) GetActivePartWorkplaneSketch(IPartDocument **activePart,
									 IGraphicDocument **activeGraphicDoc,
									 IWorkplane **activeWorkplane,
									 ISketch **activeSketch) ;

HRESULT __declspec(dllimport) GetActiveDrawingDoc(IDrawingDocument **activeDraw,
									 IGraphicDocument **activeGraphicDoc);

HRESULT __declspec(dllimport) GetProDESKTOPApplication(IApplication **proDESKTOPApp) ;

HRESULT __declspec(dllimport) RunProDESKTOP(IApplication **app) ;

HRESULT __declspec(dllimport) CloseProDESKTOP() ;

HRESULT __declspec(dllimport) UpdatePart(IPartDocument *activePart) ;

BSTR __declspec(dllimport) GetBSTR(CString str);

HRESULT __declspec(dllimport) AddComponent(CString strFileName, IDesign **component) ;

HRESULT __declspec(dllimport) CenterAxes(IGeometric *pFirstGeometric, IGeometric *pSecondGeometric) ;

HRESULT __declspec(dllimport) AlignPlanes(IDesign *design, IGeometric *pFirstGeometric, IGeometric *pSecondGeometric, double offset, CString name);

HRESULT __declspec(dllimport) MatePlanes(IDesign *design, IGeometric *pFirstGeometric, IGeometric *pSecondGeometric, double offset, CString name);

HRESULT __declspec(dllimport) OrientAxes(IGeometric *pFirstGeometric, IGeometric *pSecondGeometric) ;

HRESULT __declspec(dllimport) Massproperties(double *mass, double *volume, double *area, 
					IVector *cofgPoint, IMatrix *momentOfInertia, IVector *principalMomentsOfInertia, IMatrix *principalAxes,
					IVector *radiusOfGyration);

HRESULT __declspec(dllimport) MakeParallel(ISet *objSet) ;

HRESULT __declspec(dllimport) MakePerpendicular(ILine *line1, ILine *line2) ;

HRESULT __declspec(dllimport) MakeColinear(ISet *objSet) ;

HRESULT __declspec(dllimport) MakeTangentLineCircle(ILine *line1, ILine *circle1) ;

HRESULT __declspec(dllimport) MakeTangentCircleCircle(ILine *circle1, ILine *circle2) ;

HRESULT __declspec(dllimport) MakeConcentric(ISet *objSet) ;

HRESULT __declspec(dllimport) MakeEqualLength(ISet *objSet) ;

HRESULT __declspec(dllimport) MakeEqualRadius(ISet *objSet) ;

HRESULT __declspec(dllimport) FixLine(ISet *objSet) ;

HRESULT __declspec(dllimport) ConstrainSize(ILine *line) ;

HRESULT __declspec(dllimport) ConstrainSeparationPointToPoint(IPoint *point1, IPoint *point2) ;

HRESULT __declspec(dllimport) ConstrainSeparationPointToLine(IPoint *point1, ILine *line1) ;

HRESULT __declspec(dllimport) ConstrainSeparationLineToLine(ILine *line1, ILine *line2) ;

HRESULT __declspec(dllimport) MakeRadialDim(ILine *circle1) ;

HRESULT __declspec(dllimport) MakeAngularDim(ILine *line1, ILine *line2) ;

HRESULT __declspec(dllimport) RemoveConstraints(IObjectOrSet *objSet, long nature) ;

HRESULT __declspec(dllimport) RemoveImplicit(ISet *objectSet1, ISet **objectSet2) ;

HRESULT __declspec(dllimport) AngularDimension(IDesign *pDesign, IDrawingDocument *pDrawingdoc, IGraphic *pGraph1, IGraphic *pGraph2, IAngularDimLine **angulardim ) ;
;

HRESULT __declspec(dllimport) Datum(IDesign *pDesign,IDrawingDocument *pDrawingdoc,IGraphic *pGraph1,IDatum **datum)  ;

HRESULT __declspec(dllimport) DiametricDimension(IDesign *pDesign,IDrawingDocument *pDrawingdoc,IGraphic *pGraph1, IRadialDimLine **diametricdim)  ;

HRESULT __declspec(dllimport) GeometricalTolerance(IDesign *pDesign,IDrawingDocument *pDrawingdoc,IGraphic *pGraph1,IGeomTol **geometricaltol);

HRESULT __declspec(dllimport) LinearDimension(IDesign *pDesign, IDrawingDocument *pDrawingdoc, IGraphic *pGraph1, IGraphic *pGraph2, ILinearDimLine **lineardim);

HRESULT __declspec(dllimport) Note(IDesign *pDesign,IDrawingDocument *pDrawingdoc,IGraphic *pGraph1,INote **note) ;

HRESULT __declspec(dllimport) RadialDimension(IDesign *pDesign, IDrawingDocument *pDrawingdoc, IGraphic *pGraph1, IRadialDimLine **radialdim);

HRESULT __declspec(dllimport) DeleteLines(ISet *objectSet1) ;

HRESULT __declspec(dllimport) OffsetChain(ISet *lineSet, double offsetDistance, long offsetDirection) ;

HRESULT __declspec(dllimport) TranslateObjects(double xDistance, double yDistance, ISet *objectSet1) ;

HRESULT __declspec(dllimport) RotateObjects(double angle, ISet *objectSet1) ;

HRESULT __declspec(dllimport) ScaleObjects(double scaleFactor, ISet *objectSet1) ;

HRESULT __declspec(dllimport) RectangularDuplicate(double xNumber, double yNumber, double xSpacing,
							 double ySpacing, ISet *objectSet1) ;

HRESULT __declspec(dllimport) DuplicateLines(ISketch *sketch1, ISet *objectSet1, IMatrix *matrix1,
					   ISet *objectSet2) ;

HRESULT __declspec(dllimport) CircularDuplicate(long number, double angle, BOOL isTotalAngle,
						  ISet *objectSet1) ;

HRESULT __declspec(dllimport) DuplicateRotate(double rotationAngle, ISet *objectSet1,
						ISet *objectSet2) ;

HRESULT __declspec(dllimport) MirrorInX(ISet *objectSet1, ISet **newObjectset1) ;

HRESULT __declspec(dllimport) MirrorInY(ISet *objectSet1, ISet **newObjectset1) ;

HRESULT __declspec(dllimport) MirrorInBoth(ISet *objectSet1, ISet **newObjectset1) ;

HRESULT __declspec(dllimport) UpdateDesign() ;

HRESULT __declspec(dllimport) ConstantRadiusBlending(ISet *pedge,VARIANT_BOOL bChamfer,VARIANT_BOOL bFlipped,VARIANT_BOOL bPropagate,VARIANT_BOOL bSmoothVariation,VARIANT_BOOL bGroupEdges,double radius,CString blendName,IBlend **pBlend);

HRESULT __declspec(dllimport) VariableRadiusBlending(ISet *pedge,VARIANT_BOOL bChamfer,VARIANT_BOOL bFlipped,VARIANT_BOOL bPropagate,VARIANT_BOOL bSmoothVariation,VARIANT_BOOL bGroupEdges,double *variableRadius,double *variableParams,int noOfVariableRadius,CString blendName,IBlend **pBlend) ;

HRESULT __declspec(dllimport) CreateExtrusion(ISketch *pSketch,double distanceAbove,int distanceBelow,double taperAngle,int side,long materialStatus,CString extrusionName,IExtrusion **pExtrusion) ;

HRESULT __declspec(dllimport) CreateRevolution(ISketch *profileSketch,IGeometric *axisGeom, double revolutionAngle,long revolutionDirection,long side,long materialStatus,CString revolutionName,IRevolution **pRevolution);

HRESULT __declspec(dllimport) CreateHollow(ISet *pface,double offsetDistance,CString hollowName,IHollow **phollow) ;

HRESULT __declspec(dllimport) CreateSweep(ISketch *profileSketch,ISketch *pathSketch,long materialStatus,CString sweepName,ISweep **psweep) ;

HRESULT __declspec(dllimport) UseComponent(IDesignInstance *pComponent,long materialStatus,VARIANT_BOOL bHideComponent,CString featureName,ITool **pucomponent);

HRESULT __declspec(dllimport) UncondemnAll() ;

HRESULT __declspec(dllimport) CreateHole(ISketch *psk,ISet *pfaces,int below,long htype,long extent,double holediam,double holedpth,double tapratio,double countdiam,double countdpth,double countang,double drillang,CString holeName,IHole **pHole) ;

HRESULT __declspec(dllimport) CreateProjection(ISketch *pinputSketch,ISet *pfaces,long direction,long extent,long profileSide,double taperAngle ,long materialStatus, CString projectionName,IProjection **pprojection) ;

HRESULT __declspec(dllimport) PartOpen(CString fileName,IPartDocument **part) ;

HRESULT __declspec(dllimport) NewDrawing(IDrawingDocument **retval) ;

HRESULT __declspec(dllimport) NewPart(IPartDocument **retval) ;

HRESULT __declspec(dllimport) DrawingOpen(CString fileName,IDrawingDocument **drawing) ;

HRESULT __declspec(dllimport) PartClose() ;

HRESULT __declspec(dllimport) DrawingClose() ;

HRESULT __declspec(dllimport) CreateLine(double startX, double startY, double endX, double endY,
				   ILine **line1) ;

HRESULT __declspec(dllimport) CreateCircle(double centerX, double centerY, double radius,
					 ILine **circle1) ;

HRESULT __declspec(dllimport) CreateRectangle(double topLeftX, double topLeftY, double bottomRightX,
						double bottomRightY, ISet **rectangle1) ;

HRESULT __declspec(dllimport) CreateArcStartEndCenter(IPoint *startPoint, IPoint *endPoint,
								IPoint *center, ILine **arc1) ;

HRESULT __declspec(dllimport) CreateLinePointToPoint(IPoint *point1, IPoint *point2, ILine **line1) ;

HRESULT __declspec(dllimport) CreateLineStartToStart(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineStartToMiddle(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineStartToEnd(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineMiddleToStart(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineMiddleToMiddle(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineMiddleToEnd(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineEndToStart(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineEndToMiddle(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineEndToEnd(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineCenterToStart(ILine *circle1, ILine *line1,
								ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineCenterToMiddle(ILine *circle1, ILine *line1,
								 ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineCenterToEnd(ILine *circle1, ILine *line1,
							  ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineStartToCenter(ILine *line1, ILine *circle1,
								ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineMiddleToCenter(ILine *line1, ILine *circle1,
								 ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineEndToCenter(ILine *line1, ILine *circle1,
							  ILine **newLine1) ;

HRESULT __declspec(dllimport) CreateLineCenterToCenter(ILine *circle1, ILine *circle2,
								 ILine **newLine1) ;

HRESULT __declspec(dllimport) GetMidPoint(ILine *line1, IPoint **point1) ;

HRESULT __declspec(dllimport) ReverseAxes(IDirection **retval1, IDirection **retval2) ;

HRESULT __declspec(dllimport) RotateAxes(double angle, IDirection **retval1, IDirection **retval2) ;

HRESULT __declspec(dllimport) TranslateAxes(double xTranslation, double yTranslation, IVector **retval1) ;

HRESULT __declspec(dllimport) RepositionAxes(double xTranslation, double yTranslation, double angle,
					   IVector **retval1, IDirection **retval2, IDirection **retval3) ;

HRESULT __declspec(dllimport) Orientedplane(ITopology *pEdge,double angle,CString workplaneName,
					  CString sketchName,VARIANT_BOOL bNoSketch,long color,
					  IWorkplane **retDispatch) ;

HRESULT __declspec(dllimport) PlaneThroughObjects(ITopology *pFirstTopology, ITopology *pSecondTopology,
							CString workplaneName,CString sketchName,
							VARIANT_BOOL bNoSketch,long color,IWorkplane **retDispatch) ;

HRESULT __declspec(dllimport) Offsetplane(ITopology *pGeometry, double offsetDistance, CString workplaneName,
					CString sketchName, VARIANT_BOOL bNoSketch, long color,
					IWorkplane **retDispatch) ;

HRESULT __declspec(dllimport) Midplane(ITopology *pFirstGeometry, ITopology *pSecondGeometry,
				 CString workplaneName, CString sketchName, VARIANT_BOOL bNoSketch,
				 long color, IWorkplane **retDispatch) ;

HRESULT __declspec(dllimport) PlaneOfObject(ITopology *pFirstTopology, CString workplaneName,
					  CString sketchName, VARIANT_BOOL bNoSketch, long color,
					  IWorkplane **retDispatch) ;

HRESULT __declspec(dllimport) NewSketch(IWorkplane *pWorkplane, int color, CString sketchName,
				  ISketch **pSketch) ;

HRESULT __declspec(dllimport) HideOtherSketches(); 

#endif // __CConvenienceExports_H__
